# hdgl_minified.py
# Minified HDGL covenant: few seeds, millions of unique vectors

SEED_VECTORS = 1               # Minimal starting vectors
FOLD_STEPS = 24                # 2^24 ≈ 16.7M vectors
SEED_PARAMS = ["0x812", "0x502", "0x310", "0x192"]
FIBS = [1,1,2,3,5,8,13,21,34,55,89]

CTv_PUBKEY = "<YOUR_PUBLIC_KEY>"

script = [f"{CTv_PUBKEY} OP_CHECKSIGVERIFY"]

vector_count = SEED_VECTORS
fib_index = 0

for step in range(FOLD_STEPS):
    prev_count = vector_count
    vector_count *= 2  # exponential folding

    # Minimal fold vector instruction
    script.append(f"OP_VEC_DUP {prev_count} OP_HDGL_VEC_ADD OP_EQUALVERIFY")

    # Param addition
    script.append(f"{prev_count} {prev_count} OP_HDGL_PARAM_ADD OP_EQUALVERIFY")

    # Fibonacci uniqueness delta
    param = SEED_PARAMS[step % len(SEED_PARAMS)]
    omega_int = int(param, 16)
    fib_delta = FIBS[fib_index % len(FIBS)]
    fib_index += 1
    omega_min = omega_int + fib_delta
    omega_max = omega_int + fib_delta
    script.append(f"{omega_int} {omega_min} {omega_max} OP_WITHINVERIFY")
    script.append("")  # readability

# Finish covenant
script.append("OP_CHECKTEMPLATEVERIFY")

# Save script
full_script = "\n".join(script)
with open("hdgl_minified.vec", "w") as f:
    f.write(full_script)

print(f"=== Generated Minified HDGL Covenant: {vector_count} unique vectors ===")
print(full_script)
